<?php
namespace Path_Pilot;

class Path_Pilot_Settings_Pro {
    public function __construct() {
        // Hook removed - now rendered directly in Pro admin class
    }

    public function render_pro_settings() {
        // All rendering logic for the Pro settings page is encapsulated here
        $api_key = get_option('path_pilot_api_key', '');
        $api_status = Path_Pilot_Pro::get_api_key_status();
        $is_api_valid = $api_status['valid'];

// Create masked version of API key for display
        $masked_key = '';
        if (!empty($api_key)) {
            if (strlen($api_key) > 12) {
                // For longer keys, like LiteLLM keys (e.g., sk-...)
                $masked_key = substr($api_key, 0, 8) . '••••••••••••••••' . substr($api_key, -4);
            } else {
                // For potentially shorter keys
                $masked_key = substr($api_key, 0, 4) . '••••••••' . substr($api_key, -2);
            }
        }
        ?>
        <?php if (!$is_api_valid): ?>
            <!-- Pre-Subscription Setup UI -->
            <div class="pp-home-section pp-margin-bottom">
                <h3 class="pp-section-heading"><i class="emoji-fire"></i> Welcome to Path Pilot Pro!</h3>
                <div class="pp-home-protip">
                    <i class="icon-pilot-icon"></i>
                    <strong>Getting Started:</strong> Enter your license key below to activate Path Pilot Pro and unlock all features.
                </div>

                <div class="pp-home-stat pp-stat-card" style="max-width: 600px;">
                    <div class="pp-home-stat-label">Step 1: Enter Your License Key</div>
                        <input type="hidden" name="action" value="path_pilot_save_settings">
                        <?php wp_nonce_field('path_pilot_save_settings'); ?>

                        <?php if (!empty($api_key)): ?>
                            <!-- Existing Key Display -->
                            <div class="pp-api-key-display" style="margin: 15px 0;">
                                <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                                    <input type="text" value="<?php echo esc_attr($masked_key); ?>" readonly
                                           style="flex: 1; min-width: 250px; max-width: 350px; padding: 12px; font-size: 14px; background: #f9f9f9; color: #666; border: 2px solid #ddd; border-radius: 6px; font-family: monospace;" />
                                    <button type="button" class="pp-remove-key-btn btn" style="padding: 12px 16px; font-weight: 600; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; cursor: pointer;">
                                        Remove Key
                                    </button>
                                </div>
                                <div class="pp-remove-key-confirmation" style="display: none; margin-top: 10px; color: #d63031; font-weight: 500;">Are you sure you want to permanently delete this API key? Click again to do so.</div>
                            </div>

                            <!-- Hidden Edit Field -->
                            <div class="pp-api-key-edit" style="display: none; margin: 15px 0;">
                                <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                    <input type="password" id="path_pilot_api_key" name="path_pilot_api_key"
                                           value=""
                                           class="form-control"
                                           autocomplete="off"
                                           placeholder="Enter your new Path Pilot Pro license key..."
                                           style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                    <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key"
                                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                            title="Show/Hide API Key">
                                        <span class="pp-eye-icon">👁️</span>
                                    </button>
                                </div>
                                <div style="margin-top: 10px;">
                                    <button type="button" class="pp-cancel-change-btn" style="padding: 8px 16px; background: none; border: 1px solid #ddd; border-radius: 4px; color: #666; cursor: pointer; margin-right: 10px;">
                                        Cancel
                                    </button>
                                    <small style="color: #666;">Leave empty to keep current key</small>
                                </div>
                            </div>
                        <?php else: ?>
                            <!-- New Key Entry -->
                            <div style="margin: 15px 0;">
                                <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                    <input type="password" id="path_pilot_api_key" name="path_pilot_api_key"
                                           value=""
                                           class="form-control"
                                           autocomplete="off"
                                           placeholder="Enter your Path Pilot Pro license key..."
                                           style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                    <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key"
                                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                            title="Show/Hide API Key">
                                        <span class="pp-eye-icon">👁️</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div style="margin: 15px 0;">
                            <button type="submit" id="pp-activate-license" class="btn btn-primary" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; margin-right: 10px;">
                                Activate License Key
                            </button>
                            <button type="button" id="test-api-key" class="btn" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; background: #f8f9fa; border: 1px solid #ddd;">
                                Test Connection
                            </button>
                        </div>

                    <div id="api-test-result" style="display: none; margin: 15px 0; padding: 10px; border-radius: 4px;"></div>
                </div>

                <div class="pp-home-stat pp-stat-card" style="max-width: 600px; margin-top: 20px;">
                    <div class="pp-home-stat-label">Don't Have a License Key Yet?</div>
                    <div style="margin: 15px 0;">
                        <p style="margin-bottom: 15px; color: #666;">Path Pilot Pro provides advanced AI-powered recommendations and chat functionality for your WordPress site.</p>
                        <a href="https://pathpilot.app/pro/" target="_blank" class="btn btn-pro" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; text-decoration: none; display: inline-block;">
                            Get Your License Key →
                        </a>
                    </div>
                </div>
            </div>

        <?php else: ?>
            <!-- Full Settings Interface (API Key is Valid) -->
            <!-- Pro-only: License Key -->
            <div class="pp-home-section pp-margin-bottom">
                <h3 class="pp-section-heading"><i class="emoji-fire"></i> API Configuration</h3>
                <div class="pp-home-protip">
                    <i class="icon-pilot-icon"></i>
                    <strong>Status:</strong> <span style="color: #2ecc40; font-weight: 600;">✓ License Active</span> - Your license key and credit balance are managed here.
                </div>
                <div class="pp-home-stat pp-stat-card">
                    <div class="pp-home-stat-label">Path Pilot Pro License Key</div>

                    <?php if (!empty($api_key)): ?>
                        <!-- Existing Key Display -->
                        <div class="pp-api-key-display" style="margin: 15px 0;">
                            <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                                <input type="text" value="<?php echo esc_attr($masked_key); ?>" readonly
                                       style="flex: 1; min-width: 250px; max-width: 350px; padding: 12px; font-size: 14px; background: #f9f9f9; color: #666; border: 2px solid #ddd; border-radius: 6px; font-family: monospace;" />
                                <button type="button" class="pp-remove-key-btn btn" style="padding: 12px 16px; font-weight: 600; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; cursor: pointer;">
                                    Remove Key
                                </button>
                            </div>
                            <div class="pp-remove-key-confirmation" style="display: none; margin-top: 10px; color: #d63031; font-weight: 500;">Are you sure you want to permanently delete this API key? Click again to do so.</div>
                        </div>

                        <!-- Hidden Edit Field -->
                        <div class="pp-api-key-edit" style="display: none; margin: 15px 0;">
                            <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                <input type="password" id="path_pilot_api_key" name="path_pilot_api_key"
                                       value=""
                                       class="form-control"
                                       autocomplete="off"
                                       placeholder="Enter your new Path Pilot Pro license key..."
                                       style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key"
                                        style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                        title="Show/Hide API Key">
                                    <span class="pp-eye-icon">👁️</span>
                                </button>
                            </div>
                            <div style="margin-top: 10px;">
                                <button type="button" class="pp-cancel-change-btn" style="padding: 8px 16px; background: none; border: 1px solid #ddd; border-radius: 4px; color: #666; cursor: pointer; margin-right: 10px;">
                                    Cancel
                                </button>
                                <small style="color: #666;">Leave empty to keep current key</small>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- New Key Entry -->
                        <div style="margin: 15px 0;">
                            <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                <input type="password" id="path_pilot_api_key" name="path_pilot_api_key"
                                       value=""
                                       class="form-control"
                                       autocomplete="off"
                                       placeholder="Enter your Path Pilot Pro license key..."
                                       style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key"
                                        style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                        title="Show/Hide API Key">
                                    <span class="pp-eye-icon">👁️</span>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div style="margin: 15px 0;">
                        <button type="submit" id="pp-activate-license" class="btn btn-primary" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; margin-right: 10px;">
                            Activate License Key
                        </button>
                        <button type="button" id="test-api-key" class="btn" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; background: #f8f9fa; border: 1px solid #ddd;">
                            Test Connection
                        </button>
                                </div>

                    <div id="api-test-result" style="display: none; margin: 15px 0; padding: 10px; border-radius: 4px;"></div>

                    <div id="manage-account-container" style="margin-bottom:10px;display:none;">
                        <button id="pp-manage-account" class="btn btn-secondary" style="padding:8px 14px;font-weight:600;">Manage My Account</button>
                        <small style="margin-left:8px;color:#666;">Update billing, payment methods, and subscription</small>
                    </div>

                    <!-- Credit Balance Container - ALWAYS RENDERED -->
                    <div id="credit-balance-container" class="credit-balance-container" style="margin-top: 15px;">
                        <div id="credit-balance-loading" style="font-size: 0.9em; color: #888;">Loading credit balance...</div>
                        <div id="credit-balance-display" style="display: none;">
                            <p style="margin: 0; color: #666; margin-bottom: 5px;">
                                Current Credits: <strong id="credit-amount" style="font-size: 1.1em; color: #333;">0</strong>
                            </p>
                            <div class="progress-bar" style="width: 100%; height: 20px; background-color: #f1f1f1; border-radius: 10px; overflow: hidden; position: relative;">
                                <div class="progress-fill" id="credit-progress" style="height: 100%; background-color: #2ecc40; transition: width 0.3s ease; width: 0%;"></div>
                            </div>
                        </div>

                        <!-- Buy More Credits Section (Commented Out) -->
                        <!--
                        <h5 style="margin-top: 20px; margin-bottom: 15px;">Buy More Credits <span class="pp-pro-tag">PRO</span></h5>
                        <div class="credit-purchase-options" style="display: flex; gap: 10px; flex-wrap: wrap;">
                            <button type="button" class="btn btn-secondary buy-credits-btn" data-amount="1000" data-price="10">
                                1,000 Credits ($10)
                            </button>
                            <button type="button" class="btn btn-secondary buy-credits-btn" data-amount="5000" data-price="45">
                                5,000 Credits ($45)
                            </button>
                            <button type="button" class="btn btn-secondary buy-credits-btn" data-amount="10000" data-price="80">
                                10,000 Credits ($80)
                            </button>
                        </div>
                        -->

                        <div id="subscription-prompt" style="margin: 10px 0; padding: 12px; background: #f0f8ff; border: 1px solid #b3d9ff; border-radius: 4px; display: none;">
                            <p style="margin: 0; color: #2c3e50; font-size: 14px;">
                                <strong>💡 Need more credits?</strong>
                                <a href="https://pathpilot.app/pro/" target="_blank" style="color: #0073aa; text-decoration: none; font-weight: 600;">Subscribe to Path Pilot</a>
                                to purchase additional anytime credits that never expire.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php
    }

    // Helper to get LiteLLM API key status
    private function get_litellm_api_status($api_key) {
        // ... (existing helper function code) ...
    }

    // Helper function to get Stripe Customer ID from LiteLLM Key Metadata
    private function get_stripe_customer_id($api_key) {
        // ... (existing helper function code) ...
    }

    // Helper function to get the LiteLLM subscription ID for the current API key
    private function get_subscription_id_for_api_key($api_key) {
        // ... (existing helper function code) ...
    }

    // Helper function to get subscription ID from Stripe customer ID
    private function get_subscription_id_from_customer($customer_id) {
        // ... (existing helper function code) ...
    }

}
