<?php
namespace Path_Pilot;

class Path_Pilot_Settings_Pro {
    public function __construct() {
        add_action('path_pilot_additional_settings', [$this, 'render_pro_settings']);
    }

    public function render_pro_settings() {

        // Pro settings page
        $api_key = get_option('path_pilot_api_key', '');
        $api_status = Path_Pilot_Pro::get_api_key_status();
        $is_api_valid = $api_status['valid'];

// Create masked version of API key for display
        $masked_key = '';
        if (!empty($api_key)) {
            if (strlen($api_key) > 12) {
                // For longer keys, like LiteLLM keys (e.g., sk-...)
                $masked_key = substr($api_key, 0, 8) . '••••••••••••••••' . substr($api_key, -4);
            } else {
                // For potentially shorter keys
                $masked_key = substr($api_key, 0, 4) . '••••••••' . substr($api_key, -2);
            }
        }
        ?>
        <?php if (!$is_api_valid): ?>
            <!-- Pre-Subscription Setup UI -->
            <div class="pp-home-section pp-margin-bottom">
                <h3 class="pp-section-heading"><i class="emoji-fire"></i> Welcome to Path Pilot Pro!</h3>
                <div class="pp-home-protip">
                    <i class="icon-pilot-icon"></i>
                    <strong>Getting Started:</strong> Enter your license key below to activate Path Pilot Pro and unlock all features.
                </div>

                <div class="pp-home-stat pp-stat-card" style="max-width: 600px;">
                    <div class="pp-home-stat-label">Step 1: Enter Your License Key</div>
                        <input type="hidden" name="action" value="path_pilot_save_settings">
                        <?php wp_nonce_field('path_pilot_save_settings'); ?>

                        <?php if (!empty($api_key)): ?>
                            <!-- Existing Key Display -->
                            <div class="pp-api-key-display" style="margin: 15px 0;">
                                <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                                    <input type="text" value="<?php echo esc_attr($masked_key); ?>" readonly
                                           style="flex: 1; min-width: 250px; max-width: 350px; padding: 12px; font-size: 14px; background: #f9f9f9; color: #666; border: 2px solid #ddd; border-radius: 6px; font-family: monospace;" />
                                    <button type="button" class="pp-remove-key-btn btn" style="padding: 12px 16px; font-weight: 600; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; cursor: pointer;">
                                        Remove Key
                                    </button>
                                </div>
                                <div class="pp-remove-key-confirmation" style="display: none; margin-top: 10px; color: #d63031; font-weight: 500;">Are you sure you want to permanently delete this API key? Click again to do so.</div>
                            </div>

                            <!-- Hidden Edit Field -->
                            <div class="pp-api-key-edit" style="display: none; margin: 15px 0;">
                                <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                    <input type="password" id="path_pilot_api_key" name="path_pilot_api_key"
                                           value=""
                                           class="form-control"
                                           autocomplete="off"
                                           placeholder="Enter your new Path Pilot Pro license key..."
                                           style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                    <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key"
                                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                            title="Show/Hide API Key">
                                        <span class="pp-eye-icon">👁️</span>
                                    </button>
                                </div>
                                <div style="margin-top: 10px;">
                                    <button type="button" class="pp-cancel-change-btn" style="padding: 8px 16px; background: none; border: 1px solid #ddd; border-radius: 4px; color: #666; cursor: pointer; margin-right: 10px;">
                                        Cancel
                                    </button>
                                    <small style="color: #666;">Leave empty to keep current key</small>
                                </div>
                            </div>
                        <?php else: ?>
                            <!-- New Key Entry -->
                            <div style="margin: 15px 0;">
                                <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                    <input type="password" id="path_pilot_api_key" name="path_pilot_api_key"
                                           value=""
                                           class="form-control"
                                           autocomplete="off"
                                           placeholder="Enter your Path Pilot Pro license key..."
                                           style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                    <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key"
                                            style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                            title="Show/Hide API Key">
                                        <span class="pp-eye-icon">👁️</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($api_key) && !$is_api_valid): ?>
                            <div class="pp-error-message" style="margin: 10px 0; padding: 10px; background: #ffeaea; border: 1px solid #ff6b6b; border-radius: 4px; color: #d63031;">
                                <strong>⚠️ API Key Issue:</strong> <?php echo esc_html($api_status['message']); ?>
                            </div>
                        <?php endif; ?>

                        <div style="margin: 15px 0;">
                            <button type="submit" class="btn btn-primary" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; margin-right: 10px;">
                                Activate License Key
                            </button>
                            <button type="button" id="test-api-key" class="btn" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; background: #f8f9fa; border: 1px solid #ddd;">
                                Test Connection
                            </button>
                        </div>

                    <div id="api-test-result" style="display: none; margin: 15px 0; padding: 10px; border-radius: 4px;"></div>
                </div>

                <div class="pp-home-stat pp-stat-card" style="max-width: 600px; margin-top: 20px;">
                    <div class="pp-home-stat-label">Don't Have a License Key Yet?</div>
                    <div style="margin: 15px 0;">
                        <p style="margin-bottom: 15px; color: #666;">Path Pilot Pro provides advanced AI-powered recommendations and chat functionality for your WordPress site.</p>
                        <a href="https://pathpilot.app/pricing" target="_blank" class="btn btn-pro" style="padding: 12px 24px; font-weight: 600; font-size: 1rem; text-decoration: none; display: inline-block;">
                            Get Your License Key →
                        </a>
                    </div>
                </div>
            </div>

        <?php else: ?>
            <!-- Full Settings Interface (API Key is Valid) -->
            <!-- Pro-only: License Key -->
            <div class="pp-home-section pp-margin-bottom">
                <h3 class="pp-section-heading"><i class="emoji-fire"></i> API Configuration</h3>
                <div class="pp-home-protip">
                    <i class="icon-pilot-icon"></i>
                    <strong>Status:</strong> <span style="color: #2ecc40; font-weight: 600;">✓ License Active</span> - Your license key and credit balance are managed here.
                </div>
                <div class="pp-home-stat pp-stat-card">
                    <div class="pp-home-stat-label">Path Pilot Pro License Key</div>

                    <?php if (!empty($api_key)): ?>
                        <!-- Existing Key Display -->
                        <div class="pp-api-key-display" style="margin: 15px 0;">
                            <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                                <input type="text" value="<?php echo esc_attr($masked_key); ?>" readonly
                                       style="flex: 1; min-width: 250px; max-width: 350px; padding: 12px; font-size: 14px; background: #f9f9f9; color: #666; border: 2px solid #ddd; border-radius: 6px; font-family: monospace;" />
                                <button type="button" class="pp-remove-key-btn btn" style="padding: 12px 16px; font-weight: 600; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; cursor: pointer;">
                                    Remove Key
                                </button>
                            </div>
                            <div class="pp-remove-key-confirmation" style="display: none; margin-top: 10px; color: #d63031; font-weight: 500;">Are you sure you want to permanently delete this API key? Click again to do so.</div>
                        </div>

                        <!-- Hidden Edit Field -->
                        <div class="pp-api-key-edit" style="display: none; margin: 15px 0;">
                            <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                <input type="password" id="path_pilot_api_key_active" name="path_pilot_api_key"
                                       value=""
                                       class="form-control"
                                       autocomplete="off"
                                       placeholder="Enter your new Path Pilot Pro license key..."
                                       style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key_active"
                                        style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                        title="Show/Hide API Key">
                                    <span class="pp-eye-icon">👁️</span>
                                </button>
                            </div>
                            <div style="margin-top: 10px;">
                                <button type="button" class="pp-cancel-change-btn" style="padding: 8px 16px; background: none; border: 1px solid #ddd; border-radius: 4px; color: #666; cursor: pointer; margin-right: 10px;">
                                    Cancel
                                </button>
                                <small style="color: #666;">Leave empty to keep current key</small>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- New Key Entry -->
                        <div style="margin: 15px 0;">
                            <div class="pp-password-field-container" style="position: relative; display: inline-block; width: 100%; max-width: 450px;">
                                <input type="password" id="path_pilot_api_key_active" name="path_pilot_api_key"
                                       value=""
                                       class="form-control"
                                       autocomplete="off"
                                       placeholder="Enter your Path Pilot Pro license key..."
                                       style="width: 100%; padding: 12px 45px 12px 12px; font-size: 14px; border: 2px solid #ddd; border-radius: 6px;" />
                                <button type="button" class="pp-password-toggle" data-target="#path_pilot_api_key_active"
                                        style="position: absolute; right: 12px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer; padding: 4px; color: #666; font-size: 16px;"
                                        title="Show/Hide API Key">
                                    <span class="pp-eye-icon">👁️</span>
                                </button>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="mb-4">
                    <h4>Credit Balance</h4>
                    <div id="credit-balance-container">
                        <div id="credit-balance-loading">Loading credit balance...</div>
                        <div id="credit-balance-display" style="display: none;">
                            <div class="progress-container" style="margin: 15px 0;">
                                <div class="progress-bar" style="width: 100%; height: 20px; background-color: #f1f1f1; border-radius: 10px; overflow: hidden; position: relative;">
                                    <div class="progress-fill" id="credit-progress" style="height: 100%; background-color: #2ecc40; transition: width 0.3s ease; width: 0%;"></div>
                                </div>
                                <div class="progress-text" id="credit-text" style="margin-top: 8px; font-weight: 600; color: #333;">0 / 0 Credits Remaining</div>
                                <div id="credit-breakdown" style="display: none; margin-top: 4px; display: flex; align-items: center; gap: 6px;">
                                    <small id="credit-breakdown-text" style="color: #666;"></small>
                                    <div class="credit-info-tooltip">
                                        <span class="info-icon">i</span>
                                        <div class="tooltip-content" id="credit-help-text">
                                            <strong>Monthly:</strong> Subscription credits, reset monthly<br>
                                            <strong>Anytime:</strong> Purchased credits, never expire
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3">
                                <div id="manage-account-container" style="margin-bottom:10px;display:none;">
                                    <button id="pp-manage-account" class="btn btn-secondary" style="padding:8px 14px;font-weight:600;">Manage My Account</button>
                                    <small style="margin-left:8px;color:#666;">Update billing, payment methods, and subscription</small>
                                </div>
                                <!-- Buy More Credits temporarily disabled
                                <h5>Buy More Credits</h5>
                                <div id="manage-account-container" style="margin-bottom:10px;display:none;">
                                    <button id="pp-manage-account" class="btn btn-secondary" style="padding:8px 14px;font-weight:600;">Manage My Account</button>
                                    <small style="margin-left:8px;color:#666;">Update billing, payment methods, and subscription</small>
                                </div>
                                <div class="credit-purchase-options" style="display: flex; gap: 10px; flex-wrap: wrap; margin: 10px 0;">
                                    <a href="<?php echo esc_url($this->get_topup_link(5000)); ?>" target="_blank" class="pp-credit-btn" style="text-decoration: none; padding: 8px 16px; border: 1px solid #0073aa; color: #0073aa; border-radius: 4px; font-size: 14px; text-align: center; transition: all 0.2s;">
                                        5,000 Credits - $25
                                    </a>
                                    <a href="<?php echo esc_url($this->get_topup_link(10000)); ?>" target="_blank" class="pp-credit-btn pp-credit-btn-primary" style="text-decoration: none; padding: 8px 16px; background: #0073aa; color: white; border: 1px solid #0073aa; border-radius: 4px; font-size: 14px; text-align: center; transition: all 0.2s; font-weight: 600;">
                                        10,000 Credits - $45
                                    </a>
                                    <a href="<?php echo esc_url($this->get_topup_link(25000)); ?>" target="_blank" class="pp-credit-btn" style="text-decoration: none; padding: 8px 16px; border: 1px solid #0073aa; color: #0073aa; border-radius: 4px; font-size: 14px; text-align: center; transition: all 0.2s;">
                                        25,000 Credits - $100
                                    </a>
                                </div>
                                -->
                   
                                <style>
                                    .pp-credit-btn:hover {
                                        background: #0073aa !important;
                                        color: white !important;
                                    }
                                    .pp-credit-btn-primary:hover {
                                        background: #005a87 !important;
                                        border-color: #005a87 !important;
                                    }

                                    /* Password toggle styles */
                                    .pp-password-field-container {
                                        position: relative;
                                        display: inline-block;
                                    }

                                    .pp-password-toggle {
                                        transition: color 0.2s;
                                    }

                                    .pp-password-toggle:hover {
                                        color: #333 !important;
                                    }

                                    .pp-eye-icon {
                                        display: inline-block;
                                        font-style: normal;
                                    }
                                </style>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <script>
            jQuery(document).ready(function($) {
                // Handle password toggle functionality for API key fields
                $(document).on('click', '.pp-password-toggle', function(e) {
                    e.preventDefault();

                    const button = $(this);
                    const targetSelector = button.data('target');
                    const input = $(targetSelector);
                    const eyeIcon = button.find('.pp-eye-icon');

                    if (input.attr('type') === 'password') {
                        // Show password
                        input.attr('type', 'text');
                        button.addClass('visible');
                        button.attr('title', 'Hide API Key');
                        eyeIcon.text('🙈'); // Closed eye when visible
                    } else {
                        // Hide password
                        input.attr('type', 'password');
                        button.removeClass('visible');
                        button.attr('title', 'Show API Key');
                        eyeIcon.text('👁️'); // Open eye when hidden
                    }
                });

                // Handle Remove Key button with confirmation
                $(document).on('click', '.pp-remove-key-btn', function(e) {
                    e.preventDefault();
                    const button = $(this);
                    const confirmation = button.closest('.pp-api-key-display').find('.pp-remove-key-confirmation');

                    if (!button.data('confirmed')) {
                        // First click, show confirmation
                        $('.pp-remove-key-confirmation').slideUp(); // Hide others
                        $('.pp-remove-key-btn').data('confirmed', false); // Reset others

                        confirmation.slideDown();
                        button.data('confirmed', true);
                    } else {
                        // Second click, proceed with deletion
                        confirmation.text('Removing key...').slideDown();

                        $.ajax({
                            url: '/wp-json/path-pilot/v1/delete-api-key',
                            method: 'POST',
                            contentType: 'application/json',
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('X-WP-Nonce', wpApiSettings.nonce);
                            },
                            success: function(response) {
                                location.reload();
                            },
                            error: function() {
                                confirmation.text('Error deleting key. Please try again.').slideDown();
                                button.data('confirmed', false);
                            }
                        });
                    }
                });

                // Handle Cancel Change button
                $(document).on('click', '.pp-cancel-change-btn', function(e) {
                    e.preventDefault();

                    const container = $(this).closest('.pp-home-stat-card');
                    const displayDiv = container.find('.pp-api-key-display');
                    const editDiv = container.find('.pp-api-key-edit');
                    const input = editDiv.find('input[type="password"], input[type="text"]');

                    // Clear the input and reset to password type
                    input.val('').attr('type', 'password');

                    // Reset toggle button
                    const toggleBtn = editDiv.find('.pp-password-toggle');
                    toggleBtn.removeClass('visible').attr('title', 'Show API Key');
                    toggleBtn.find('.pp-eye-icon').text('👁️');

                    // Show display, hide edit
                    editDiv.hide();
                    displayDiv.show();
                });

                // Hide confirmation messages if user clicks elsewhere
                $(document).on('click', function(e) {
                    if (!$(e.target).closest('.pp-remove-key-btn').length && !$(e.target).closest('.pp-remove-key-confirmation').length) {
                        $('.pp-remove-key-confirmation').slideUp();
                        $('.pp-remove-key-btn').data('confirmed', false);
                    }
                });
            });
        </script>
        <style>
            .credit-info-tooltip {
                position: relative;
                display: inline-block;
            }

            .info-icon {
                display: inline-flex;
                align-items: center;
                justify-content: center;
                width: 16px;
                height: 16px;
                background: #2271b1;
                color: white;
                border-radius: 50%;
                font-size: 10px;
                font-weight: bold;
                cursor: help;
                transition: background-color: 0.2s;
            }

            .info-icon:hover {
                background: #135e96;
            }

            .tooltip-content {
                position: absolute;
                bottom: 125%;
                left: 50%;
                transform: translateX(-50%);
                background: #333;
                color: white;
                padding: 8px 12px;
                border-radius: 4px;
                font-size: 12px;
                line-height: 1.3;
                white-space: nowrap;
                opacity: 0;
                visibility: hidden;
                transition: opacity 0.3s, visibility 0.3s;
                z-index: 1000;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
                max-width: 250px;
                white-space: normal;
            }

            .tooltip-content::after {
                content: '';
                position: absolute;
                top: 100%;
                left: 50%;
                transform: translateX(-50%);
                border: 5px solid transparent;
                border-top-color: #333;
            }

            .credit-info-tooltip:hover .tooltip-content {
                opacity: 1;
                visibility: visible;
            }

            @media (max-width: 768px) {
                .tooltip-content {
                    left: 0;
                    transform: none;
                    max-width: 200px;
                }

                .tooltip-content::after {
                    left: 20px;
                    transform: none;
                }
            }

            /* Password toggle styles */
            .pp-password-field-container {
                position: relative;
                display: inline-block;
            }

            .pp-password-toggle {
                position: absolute;
                right: 12px;
                top: 50%;
                transform: translateY(-50%);
                background: none;
                border: none;
                cursor: pointer;
                padding: 4px;
                color: #666;
                font-size: 16px;
                transition: color 0.2s;
            }

            .pp-password-toggle:hover {
                color: #333;
            }

            .pp-eye-icon {
                display: inline-block;
                font-style: normal;
            }
        </style>

        <?php
    }
    // Function to generate topup links with subscription ID
    private function get_topup_link($credits) {
        // Actual Stripe Payment Link URLs
        $payment_links = [
            5000 => 'https://buy.stripe.com/00w14o95k4cH9KQcmO9EI01',   // 5,000 credits - $25
            10000 => 'https://buy.stripe.com/dRm7sM3L0bF9bSY4Um9EI02',  // 10,000 credits - $45
            25000 => 'https://buy.stripe.com/eVq9AU3L0gZt8GM4Um9EI03'   // 25,000 credits - $100
        ];

        if (!isset($payment_links[$credits])) {
            return '#';
        }

        // Get subscription ID - this would need to be retrieved from your system
        // For now, using a placeholder - you'll need to implement this
        $subscription_id = $this->get_user_subscription_id();
        $installation_domain = parse_url(home_url(), PHP_URL_HOST);

        $url = $payment_links[$credits];
        if ($subscription_id) {
            $url .= '?client_reference_id=' . urlencode($subscription_id);
            $url .= '&domain=' . urlencode($installation_domain);
        }

        return $url;
    }

    // Function to get the current user's subscription ID
    private function get_user_subscription_id() {
        // Check transient cache first (valid for 1 hour)
        $cache_key = 'path_pilot_subscription_id';
        $cached_subscription_id = get_transient($cache_key);

        if ($cached_subscription_id !== false) {
            return $cached_subscription_id;
        }

        // Not cached, fetch from LiteLLM key metadata
        $api_key = get_option('path_pilot_api_key', '');
        if (empty($api_key)) {
            return null;
        }

        try {
            // Get LiteLLM key info which contains subscription ID in metadata
            $url = PATH_PILOT_AI_API_URL . '/key/info';
            $args = [
                'headers' => [
                    'Authorization' => 'Bearer ' . $api_key,
                ],
                'timeout' => 15,
                'sslverify' => (strpos(home_url(), 'localhost') !== false || strpos(home_url(), '.local') !== false),
            ];

            $response = wp_remote_get($url, $args);

            if (is_wp_error($response)) {
                Log::info('Path Pilot: Failed to get subscription ID from LiteLLM: ' . $response->get_error_message());
                return null;
            }

            $response_code = wp_remote_retrieve_response_code($response);
            if ($response_code !== 200) {
                Log::info('Path Pilot: LiteLLM API returned error code: ' . $response_code);
                return null;
            }

            $body = wp_remote_retrieve_body($response);
            $data = json_decode($body, true);

            // Extract subscription ID from metadata
            $subscription_id = null;
            if (isset($data['info']['metadata']['user_id'])) {
                // The user_id in metadata is actually the Stripe customer ID
                // We need to get the subscription ID differently

                // Check if there's a direct subscription_id in metadata
                if (isset($data['info']['metadata']['subscription_id'])) {
                    $subscription_id = $data['info']['metadata']['subscription_id'];
                } else {
                    // If not stored directly, we'll need to find it via Stripe API
                    $customer_id = $data['info']['metadata']['user_id'];
                    $subscription_id = $this->get_subscription_id_from_customer($customer_id);
                }
            }

            if ($subscription_id) {
                // Cache for 1 hour to avoid repeated API calls
                set_transient($cache_key, $subscription_id, HOUR_IN_SECONDS);
                return $subscription_id;
            }

        } catch (Exception $e) {
            Log::info('Path Pilot: Error retrieving subscription ID: ' . $e->getMessage());
        }

        return null;
    }

    // Helper function to get subscription ID from Stripe customer ID
    private function get_subscription_id_from_customer($customer_id) {
        if (!$customer_id) {
            return null;
        }

        // Check transient cache for customer->subscription mapping
        $cache_key = 'path_pilot_customer_subscription_' . $customer_id;
        $cached_subscription_id = get_transient($cache_key);

        if ($cached_subscription_id !== false) {
            return $cached_subscription_id;
        }

        try {
            // This would require Stripe API access from WordPress
            // For now, we'll return null and rely on the webhook to store subscription_id directly in metadata
            // You could implement Stripe API calls here if needed

            return null;

        } catch (Exception $e) {
            Log::info('Path Pilot: Error getting subscription from customer: ' . $e->getMessage());
            return null;
        }
    }

}
