// Path Pilot Embeddings AJAX Recompute
jQuery(function($) {
    // Only run if the button exists
    var $btn = $('#pp-recompute-embeddings-ajax');
    if (!$btn.length) return;

    var $progress = $('#pp-embedding-progress');
    var running = false;

    
    function showProgress(msg, percent) {
        if (!$progress.length) return;
        $progress.html('<div class="pp-stat-waiting" style="margin:10px 0;">' + msg + '</div>' +
            '<div class="pp-progress-bar"><div class="pp-progress-value" style="width:' + percent + '%"></div></div>');
    }

    function fetchPagesNeedingEmbeddings(callback) {
        $.post(PathPilotEmbeddings.ajax_url, {
            action: 'path_pilot_get_pages_needing_embeddings',
            _ajax_nonce: PathPilotEmbeddings.nonce
        }, function(resp) {
            if (resp.success && resp.data && resp.data.ids) {
                callback(resp.data.ids);
            } else {
                alert('Failed to fetch pages needing embeddings.');
                running = false;
            }
        });
    }

    function processBatch(ids, done, total, failed, errorMap) {
        if (!ids.length) {
            if (errorMap && Object.keys(errorMap).length) {
                var errorHtml = '<div class="pp-sync-error">Some embeddings failed:</div><ul style="color:#b00;font-size:0.98em;">';
                for (var id in errorMap) {
                    errorHtml += '<li>Post ID ' + id + ': ' + errorMap[id] + '</li>';
                }
                errorHtml += '</ul>';
                $progress.html(errorHtml + '<div class="pp-progress-bar"><div class="pp-progress-value" style="width:100%"></div></div>');
                console.warn('Failed to process these IDs:', errorMap);
            } else if (failed && failed.length) {
                showProgress('All batches processed, but ' + failed.length + ' failed. See console for details.', 100);
                console.warn('Failed to process these IDs:', failed);
            } else {
                showProgress('All embeddings up to date!', 100);
            }
            running = false;
            if (typeof done === 'function') done();
            return;
        }
        var batch_size = 5;
        var batch = ids.slice(0, batch_size);
        var remaining = ids.slice(batch_size);
        var processed = total - remaining.length - batch.length;
        var percent = Math.round((processed / total) * 100);
        showProgress('Processing ' + (processed + 1) + '–' + (processed + batch.length) + ' of ' + total + '...', percent);
        console.log('Processing batch:', batch);
        $.post(PathPilotEmbeddings.ajax_url, {
            action: 'path_pilot_recompute_embeddings_batch',
            ids: batch,
            _ajax_nonce: PathPilotEmbeddings.nonce
        }, function(resp) {
            if (resp.success) {
                // Merge errors from this batch
                if (resp.data && resp.data.errors) {
                    errorMap = errorMap || {};
                    Object.assign(errorMap, resp.data.errors);
                }
                setTimeout(function() {
                    processBatch(remaining, done, total, failed, errorMap);
                }, 1200); // throttle
            } else {
                // If failed, add these IDs to the failed list and continue
                failed = failed || [];
                failed = failed.concat(batch);
                showProgress('Error: ' + (resp.data && resp.data.message ? resp.data.message : 'Unknown error') + '. Skipping batch.', percent);
                setTimeout(function() {
                    processBatch(remaining, done, total, failed, errorMap);
                }, 1200);
            }
        });
    }

    $btn.on('click', function(e) {
        e.preventDefault();
        if (running) return;
        running = true;
        $btn.prop('disabled', true);
        showProgress('Fetching pages needing embeddings...', 0);
        $('#pp-embedding-progress-container').hide();
    
        fetchPagesNeedingEmbeddings(function(ids) {
            if (!ids.length) {
                showProgress('All embeddings are already up to date!', 100);
                $btn.prop('disabled', false);
                running = false;
                return;
            }
            processBatch(ids, function() {
                $btn.prop('disabled', false);
                running = false;
                console.log('Embedding sync complete.');
            }, ids.length, [], {});
        });
    });
}); 