<?php
namespace Path_Pilot;

// AI API integration for Path Pilot (Pro only)
if (!defined('ABSPATH')) exit;

class Path_Pilot_Chat {
    public function __construct() {
        add_filter('path_pilot_chat_enabled', [$this, 'chat_enabled']);
    }

    public function chat_enabled($chat_enabled) {
        $api_key = Path_Pilot_Pro::get_api_key();
        $has_valid_api_key = Path_Pilot_Pro::is_api_key_valid($api_key);

        // Also check if chat should be enabled (valid API key + available credits)
        if ($has_valid_api_key) {
            // Check if we're on localhost - if so, allow chat for valid subscribers
            $current_domain = parse_url(home_url(), PHP_URL_HOST);
            $is_localhost = in_array($current_domain, ['localhost', '127.0.0.1', '::1']) || strpos($current_domain, '.local') !== false;

            if ($is_localhost) {
                // On localhost, just check subscription status
                $subscription_status = Path_Pilot_Pro::get_subscription_status($api_key);
                Log::info('Path Pilot: Subscription status = ' . print_r($subscription_status, true));
                $chat_enabled = $subscription_status['has_active_subscription'];
            } else {
                // On production, check credit balance
                $credit_data = Path_Pilot_Pro::get_all_credit_balances($api_key);
                if (!is_wp_error($credit_data) && $credit_data) {
                    $total_remaining = $credit_data['total_remaining'] ?? 0;
                    $chat_enabled = $total_remaining > 0;
                }
            }
        }
        return $chat_enabled;
    }
}
